/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.ntutil;

import java.io.File;

public class TempPath {
    static final int MAX_PATH = 260;
    private static String TEMP_DIR = null;
    private static File TEMP_DIR_FILE = null;

    public static synchronized String getPath() throws Exception {
        if (TEMP_DIR == null) {
            File f = File.createTempFile("VWM", null);
            TEMP_DIR_FILE = f.getParentFile();
            TEMP_DIR = f.getParent() + File.separatorChar;
            f.delete();
        }
        return TEMP_DIR;
    }

    public static synchronized String getTempFileName() throws Exception {
        File f = File.createTempFile("VWM", null, TEMP_DIR_FILE);
        String s = f.getCanonicalPath();
        f.delete();
        return s;
    }

    public static synchronized String getTempFileName(String path) throws Exception {
        File f = File.createTempFile("VWM", null, new File(path));
        String s = f.getCanonicalPath();
        f.delete();
        return s;
    }

    public static synchronized String getTempFileNameWithoutPath(String path) throws Exception {
        return TempPath.getTempFileName(path).substring(path.length());
    }

    public static synchronized String createTempDirectory() throws Exception {
        File f = File.createTempFile("VWM", null, TEMP_DIR_FILE);
        String s = f.getCanonicalPath();
        f.delete();
        f.mkdir();
        return s;
    }

    public static synchronized void removeDirectory(String dir) throws Exception {
        new File(dir).delete();
    }

    public static synchronized void deleteFile(String fileName) throws Exception {
        new File(fileName).delete();
    }

    public static void main(String[] args) {
        try {
            String s = TempPath.getPath();
            System.out.println("TempPath.getPath=" + s);
            s = TempPath.createTempDirectory();
            System.out.println("TempPath.createTempDirectory=" + s + ".. check the directory's existence");
            System.out.println("press any key to remove " + s);
            System.in.read();
            TempPath.removeDirectory(s);
            System.out.println("Removed directory.. " + s + ", please check");
            s = TempPath.getTempFileName();
            System.out.println("TempPath.getTempFileName=" + s);
            s = TempPath.getTempFileName("c:\\delme");
            System.out.println("TempPath.getTempFileName--in c:\\delme=" + s);
            s = TempPath.getTempFileNameWithoutPath(TempPath.getPath());
            System.out.println("TempPath.getTempFileNameWithoutPath for " + TempPath.getPath() + "=" + s);
            s = TempPath.getTempFileNameWithoutPath("c:\\delme");
            System.out.println("TempPath.getTempFileNameWithoutPath for c:\\delme= " + s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

